<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CountryGroup extends Model 
{

    protected $table = 'country_group';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'group_id');

    public function group()
    {
        return $this->belongsTo('Group');
    }

    public function country()
    {
        return $this->belongsTo('Country');
    }

}